/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of site.
 */
public class SiteKeys implements KeyInfo<DefaultSite> {
    protected SvcId siteId;
    /**
     * Returns the attribute siteId.
     *
     * @return siteId value of siteId
     */
    public SvcId siteId() {
        return siteId;
    }

    /**
     * Sets the value to attribute siteId.
     *
     * @param siteId value of siteId
     */
    public void siteId(SvcId siteId) {
        this.siteId = siteId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(siteId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SiteKeys) {
            SiteKeys other = (SiteKeys) obj;
            return
                Objects.deepEquals(siteId, other.siteId);
        }
        return false;
    }
}