/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.ipconnection.oam;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.ipconnection.oam.bfd.Holdtime;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of bfd.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultBfd extends InnerModelObject implements Bfd {
    protected boolean bfdEnabled;
    protected BitSet valueLeafFlags = new BitSet();
    protected Holdtime holdtime;

    @Override
    public boolean bfdEnabled() {
        return bfdEnabled;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Holdtime holdtime() {
        return holdtime;
    }

    @Override
    public void bfdEnabled(boolean bfdEnabled) {
        valueLeafFlags.set(LeafIdentifier.BFDENABLED.getLeafIndex());
        this.bfdEnabled = bfdEnabled;
    }

    @Override
    public void holdtime(Holdtime holdtime) {
        this.holdtime = holdtime;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bfdEnabled, valueLeafFlags, holdtime);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultBfd) {
            DefaultBfd other = (DefaultBfd) obj;
            return
                Objects.deepEquals(bfdEnabled, other.bfdEnabled) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(holdtime, other.holdtime);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("bfdEnabled=" + bfdEnabled)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("holdtime=" + holdtime)
            .toString();
    }


    /**
     * Creates an instance of defaultBfd.
     */
    public DefaultBfd() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}