/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitediversity;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitediversity.sitediversity.Groups;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of siteDiversity.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSiteDiversity extends InnerModelObject implements SiteDiversity {
    protected Groups groups;

    @Override
    public Groups groups() {
        return groups;
    }

    @Override
    public void groups(Groups groups) {
        this.groups = groups;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groups);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSiteDiversity) {
            DefaultSiteDiversity other = (DefaultSiteDiversity) obj;
            return
                Objects.deepEquals(groups, other.groups);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("groups=" + groups)
            .toString();
    }


    /**
     * Creates an instance of defaultSiteDiversity.
     */
    public DefaultSiteDiversity() {
    }

}