/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitemanagement;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of management.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultManagement extends InnerModelObject implements Management {
    protected Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.Management> type;
    protected Class<? extends AddressFamily> managementTransport;
    protected IpAddress address;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.Management> type() {
        return type;
    }

    @Override
    public Class<? extends AddressFamily> managementTransport() {
        return managementTransport;
    }

    @Override
    public IpAddress address() {
        return address;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void type(Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.Management> type) {
        valueLeafFlags.set(LeafIdentifier.TYPE.getLeafIndex());
        this.type = type;
    }

    @Override
    public void managementTransport(Class<? extends AddressFamily> managementTransport) {
        valueLeafFlags.set(LeafIdentifier.MANAGEMENTTRANSPORT.getLeafIndex());
        this.managementTransport = managementTransport;
    }

    @Override
    public void address(IpAddress address) {
        valueLeafFlags.set(LeafIdentifier.ADDRESS.getLeafIndex());
        this.address = address;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, managementTransport, address, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultManagement) {
            DefaultManagement other = (DefaultManagement) obj;
            return
                Objects.deepEquals(type, other.type) &&
                Objects.deepEquals(managementTransport, other.managementTransport) &&
                Objects.deepEquals(address, other.address) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("type=" + type)
            .add("managementTransport=" + managementTransport)
            .add("address=" + address)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultManagement.
     */
    public DefaultManagement() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}