/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitemanagement;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of management.
 */
public interface Management extends Augmentable  {

    /**
     * Identify the leaf of Management.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents type.
         */
        TYPE(1),
        /**
         * Represents managementTransport.
         */
        MANAGEMENTTRANSPORT(2),
        /**
         * Represents address.
         */
        ADDRESS(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.Management> type();

    /**
     * Returns the attribute managementTransport.
     *
     * @return managementTransport value of managementTransport
     */
    Class<? extends AddressFamily> managementTransport();

    /**
     * Returns the attribute address.
     *
     * @return address value of address
     */
    IpAddress address();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.Management> type);

    /**
     * Sets the attribute managementTransport.
     *
     * @param managementTransport value of managementTransport
     */
    void managementTransport(Class<? extends AddressFamily> managementTransport);

    /**
     * Sets the attribute address.
     *
     * @param address value of address
     */
    void address(IpAddress address);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}