/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol.yangautoprefixstatic.cascadedlanprefixes;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Prefix;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of ipv4LanPrefixes.
 */
public interface Ipv4LanPrefixes extends Augmentable  {

    /**
     * Identify the leaf of Ipv4LanPrefixes.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents lan.
         */
        LAN(1),
        /**
         * Represents lanTag.
         */
        LANTAG(2),
        /**
         * Represents nextHop.
         */
        NEXTHOP(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute lan.
     *
     * @return lan value of lan
     */
    Ipv4Prefix lan();

    /**
     * Returns the attribute lanTag.
     *
     * @return lanTag value of lanTag
     */
    String lanTag();

    /**
     * Returns the attribute nextHop.
     *
     * @return nextHop value of nextHop
     */
    Ipv4Address nextHop();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute lan.
     *
     * @param lan value of lan
     */
    void lan(Ipv4Prefix lan);

    /**
     * Sets the attribute lanTag.
     *
     * @param lanTag value of lanTag
     */
    void lanTag(String lanTag);

    /**
     * Sets the attribute nextHop.
     *
     * @param nextHop value of nextHop
     */
    void nextHop(Ipv4Address nextHop);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}