/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurityencryption.encryption.encryptionprofile.profile;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurityencryption.encryption.encryptionprofile.Profile;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of providerProfile.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultProviderProfile extends InnerModelObject implements ProviderProfile {
    protected String profileName;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String profileName() {
        return profileName;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void profileName(String profileName) {
        valueLeafFlags.set(LeafIdentifier.PROFILENAME.getLeafIndex());
        this.profileName = profileName;
    }

    @Override
    public int hashCode() {
        return Objects.hash(profileName, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultProviderProfile) {
            DefaultProviderProfile other = (DefaultProviderProfile) obj;
            return
                Objects.deepEquals(profileName, other.profileName) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("profileName=" + profileName)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultProviderProfile.
     */
    public DefaultProviderProfile() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}