/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservice;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicempls.Carrierscarrier;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicemulticast.Multicast;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.Qos;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of service.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultService extends InnerModelObject implements Service {
    protected long svcInputBandwidth;
    protected long svcOutputBandwidth;
    protected int svcMtu;
    protected BitSet valueLeafFlags = new BitSet();
    protected Qos qos;
    protected Carrierscarrier carrierscarrier;
    protected Multicast multicast;

    @Override
    public long svcInputBandwidth() {
        return svcInputBandwidth;
    }

    @Override
    public long svcOutputBandwidth() {
        return svcOutputBandwidth;
    }

    @Override
    public int svcMtu() {
        return svcMtu;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Qos qos() {
        return qos;
    }

    @Override
    public Carrierscarrier carrierscarrier() {
        return carrierscarrier;
    }

    @Override
    public Multicast multicast() {
        return multicast;
    }

    @Override
    public void svcInputBandwidth(long svcInputBandwidth) {
        valueLeafFlags.set(LeafIdentifier.SVCINPUTBANDWIDTH.getLeafIndex());
        this.svcInputBandwidth = svcInputBandwidth;
    }

    @Override
    public void svcOutputBandwidth(long svcOutputBandwidth) {
        valueLeafFlags.set(LeafIdentifier.SVCOUTPUTBANDWIDTH.getLeafIndex());
        this.svcOutputBandwidth = svcOutputBandwidth;
    }

    @Override
    public void svcMtu(int svcMtu) {
        valueLeafFlags.set(LeafIdentifier.SVCMTU.getLeafIndex());
        this.svcMtu = svcMtu;
    }

    @Override
    public void qos(Qos qos) {
        this.qos = qos;
    }

    @Override
    public void carrierscarrier(Carrierscarrier carrierscarrier) {
        this.carrierscarrier = carrierscarrier;
    }

    @Override
    public void multicast(Multicast multicast) {
        this.multicast = multicast;
    }

    @Override
    public int hashCode() {
        return Objects.hash(svcInputBandwidth, svcOutputBandwidth, svcMtu, valueLeafFlags, qos, carrierscarrier, multicast);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultService) {
            DefaultService other = (DefaultService) obj;
            return
                Objects.deepEquals(svcInputBandwidth, other.svcInputBandwidth) &&
                Objects.deepEquals(svcOutputBandwidth, other.svcOutputBandwidth) &&
                Objects.deepEquals(svcMtu, other.svcMtu) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(qos, other.qos) &&
                Objects.deepEquals(carrierscarrier, other.carrierscarrier) &&
                Objects.deepEquals(multicast, other.multicast);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("svcInputBandwidth=" + svcInputBandwidth)
            .add("svcOutputBandwidth=" + svcOutputBandwidth)
            .add("svcMtu=" + svcMtu)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("qos=" + qos)
            .add("carrierscarrier=" + carrierscarrier)
            .add("multicast=" + multicast)
            .toString();
    }


    /**
     * Creates an instance of defaultService.
     */
    public DefaultService() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}