/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicempls.carrierscarrier;

/**
 * Represents ENUM data of signallingTypeEnum.
 */
public enum SignallingTypeEnum {

    /**
     * Represents ldp.
     */
    LDP(0, "ldp"),

    /**
     * Represents bgp.
     */
    BGP(1, "bgp");

    private int signallingTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of signallingTypeEnum.
     *
     * @param signallingTypeEnum value of signallingTypeEnum
     */
     SignallingTypeEnum(int signallingTypeEnum, String schemaName) {
        this.signallingTypeEnum = signallingTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of signallingTypeEnum for.
     *
     * @param value value of signallingTypeEnum for
     * @return signallingTypeEnum for
     */
    public static SignallingTypeEnum of(int value) {
        switch (value) {
            case 0:
                return SignallingTypeEnum.LDP;
            case 1:
                return SignallingTypeEnum.BGP;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of signallingTypeEnum for.
     *
     * @param value value of signallingTypeEnum for
     * @return signallingTypeEnum for
     */
    public static SignallingTypeEnum of(String value) {
        switch (value) {
            case "ldp":
                return SignallingTypeEnum.LDP;
            case "bgp":
                return SignallingTypeEnum.BGP;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute signallingTypeEnum.
     *
     * @return signallingTypeEnum value of signallingTypeEnum
     */
    public int signallingTypeEnum() {
        return signallingTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
