/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicemulticast;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicemulticast.multicast.MulticastSiteTypeEnum;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicemulticast.multicast.MulticastTransportProtocol;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicemulticast.multicast.ProtocolTypeEnum;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of multicast.
 */
public interface Multicast extends Augmentable  {

    /**
     * Identify the leaf of Multicast.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents multicastSiteType.
         */
        MULTICASTSITETYPE(1),
        /**
         * Represents protocolType.
         */
        PROTOCOLTYPE(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute multicastSiteType.
     *
     * @return multicastSiteType value of multicastSiteType
     */
    MulticastSiteTypeEnum multicastSiteType();

    /**
     * Returns the attribute protocolType.
     *
     * @return protocolType value of protocolType
     */
    ProtocolTypeEnum protocolType();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute multicastTransportProtocol.
     *
     * @return multicastTransportProtocol value of multicastTransportProtocol
     */
    MulticastTransportProtocol multicastTransportProtocol();

    /**
     * Sets the attribute multicastSiteType.
     *
     * @param multicastSiteType value of multicastSiteType
     */
    void multicastSiteType(MulticastSiteTypeEnum multicastSiteType);

    /**
     * Sets the attribute protocolType.
     *
     * @param protocolType value of protocolType
     */
    void protocolType(ProtocolTypeEnum protocolType);

    /**
     * Sets the attribute multicastTransportProtocol.
     *
     * @param multicastTransportProtocol value of multicastTransportProtocol
     */
    void multicastTransportProtocol(MulticastTransportProtocol multicastTransportProtocol);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}