/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicemulticast.multicast;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of multicastTransportProtocol.
 */
public interface MulticastTransportProtocol extends Augmentable  {

    /**
     * Identify the leaf of MulticastTransportProtocol.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents ipv4.
         */
        IPV4(1),
        /**
         * Represents ipv6.
         */
        IPV6(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute ipv4.
     *
     * @return ipv4 value of ipv4
     */
    boolean ipv4();

    /**
     * Returns the attribute ipv6.
     *
     * @return ipv6 value of ipv6
     */
    boolean ipv6();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute ipv4.
     *
     * @param ipv4 value of ipv4
     */
    void ipv4(boolean ipv4);

    /**
     * Sets the attribute ipv6.
     *
     * @param ipv6 value of ipv6
     */
    void ipv6(boolean ipv6);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}