/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosprofile.qosprofile.custom.classes;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of yangAutoPrefixClass.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultYangAutoPrefixClass extends InnerModelObject 
        implements YangAutoPrefixClass, MultiInstanceObject<YangAutoPrefixClassKeys> {
    protected String classId;
    protected short rateLimit;
    protected short priorityLevel;
    protected short guaranteedBwPercent;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String classId() {
        return classId;
    }

    @Override
    public short rateLimit() {
        return rateLimit;
    }

    @Override
    public short priorityLevel() {
        return priorityLevel;
    }

    @Override
    public short guaranteedBwPercent() {
        return guaranteedBwPercent;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void classId(String classId) {
        valueLeafFlags.set(LeafIdentifier.CLASSID.getLeafIndex());
        this.classId = classId;
    }

    @Override
    public void rateLimit(short rateLimit) {
        valueLeafFlags.set(LeafIdentifier.RATELIMIT.getLeafIndex());
        this.rateLimit = rateLimit;
    }

    @Override
    public void priorityLevel(short priorityLevel) {
        valueLeafFlags.set(LeafIdentifier.PRIORITYLEVEL.getLeafIndex());
        this.priorityLevel = priorityLevel;
    }

    @Override
    public void guaranteedBwPercent(short guaranteedBwPercent) {
        valueLeafFlags.set(LeafIdentifier.GUARANTEEDBWPERCENT.getLeafIndex());
        this.guaranteedBwPercent = guaranteedBwPercent;
    }

    @Override
    public int hashCode() {
        return Objects.hash(classId, rateLimit, priorityLevel, guaranteedBwPercent, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultYangAutoPrefixClass) {
            DefaultYangAutoPrefixClass other = (DefaultYangAutoPrefixClass) obj;
            return
                Objects.deepEquals(classId, other.classId) &&
                Objects.deepEquals(rateLimit, other.rateLimit) &&
                Objects.deepEquals(priorityLevel, other.priorityLevel) &&
                Objects.deepEquals(guaranteedBwPercent, other.guaranteedBwPercent) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("classId=" + classId)
            .add("rateLimit=" + rateLimit)
            .add("priorityLevel=" + priorityLevel)
            .add("guaranteedBwPercent=" + guaranteedBwPercent)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultYangAutoPrefixClass.
     */
    public DefaultYangAutoPrefixClass() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}