/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of vpnPolicy.
 */
public class VpnPolicyKeys implements KeyInfo<DefaultVpnPolicy> {
    protected SvcId vpnPolicyId;
    /**
     * Returns the attribute vpnPolicyId.
     *
     * @return vpnPolicyId value of vpnPolicyId
     */
    public SvcId vpnPolicyId() {
        return vpnPolicyId;
    }

    /**
     * Sets the value to attribute vpnPolicyId.
     *
     * @param vpnPolicyId value of vpnPolicyId
     */
    public void vpnPolicyId(SvcId vpnPolicyId) {
        this.vpnPolicyId = vpnPolicyId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(vpnPolicyId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VpnPolicyKeys) {
            VpnPolicyKeys other = (VpnPolicyKeys) obj;
            return
                Objects.deepEquals(vpnPolicyId, other.vpnPolicyId);
        }
        return false;
    }
}