/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.lan.lanprefix;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.lan.lanprefix.lanprefixes.Ipv4LanPrefixes;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.lan.lanprefix.lanprefixes.Ipv6LanPrefixes;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of lanPrefixes.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLanPrefixes extends InnerModelObject implements LanPrefixes {
    protected List<Ipv4LanPrefixes> ipv4LanPrefixes;
    protected List<Ipv6LanPrefixes> ipv6LanPrefixes;

    @Override
    public List<Ipv4LanPrefixes> ipv4LanPrefixes() {
        return ipv4LanPrefixes;
    }

    @Override
    public List<Ipv6LanPrefixes> ipv6LanPrefixes() {
        return ipv6LanPrefixes;
    }

    @Override
    public void ipv4LanPrefixes(List<Ipv4LanPrefixes> ipv4LanPrefixes) {
        this.ipv4LanPrefixes = ipv4LanPrefixes;
    }

    @Override
    public void ipv6LanPrefixes(List<Ipv6LanPrefixes> ipv6LanPrefixes) {
        this.ipv6LanPrefixes = ipv6LanPrefixes;
    }

    @Override
    public void addToIpv4LanPrefixes(Ipv4LanPrefixes addTo) {
        if (ipv4LanPrefixes == null) {
            ipv4LanPrefixes = new ArrayList<>();
        }
        ipv4LanPrefixes.add(addTo);
    }


    @Override
    public void addToIpv6LanPrefixes(Ipv6LanPrefixes addTo) {
        if (ipv6LanPrefixes == null) {
            ipv6LanPrefixes = new ArrayList<>();
        }
        ipv6LanPrefixes.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(ipv4LanPrefixes, ipv6LanPrefixes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLanPrefixes) {
            DefaultLanPrefixes other = (DefaultLanPrefixes) obj;
            return
                Objects.deepEquals(ipv4LanPrefixes, other.ipv4LanPrefixes) &&
                Objects.deepEquals(ipv6LanPrefixes, other.ipv6LanPrefixes);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("ipv4LanPrefixes=" + ipv4LanPrefixes)
            .add("ipv6LanPrefixes=" + ipv6LanPrefixes)
            .toString();
    }


    /**
     * Creates an instance of defaultLanPrefixes.
     */
    public DefaultLanPrefixes() {
    }

}