/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.transportconstraints.transportconstraints.multicasttransportconstraints;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of constraint.
 */
public class ConstraintKeys implements KeyInfo<DefaultConstraint> {
    protected SvcId constraintId;
    /**
     * Returns the attribute constraintId.
     *
     * @return constraintId value of constraintId
     */
    public SvcId constraintId() {
        return constraintId;
    }

    /**
     * Sets the value to attribute constraintId.
     *
     * @param constraintId value of constraintId
     */
    public void constraintId(SvcId constraintId) {
        this.constraintId = constraintId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(constraintId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConstraintKeys) {
            ConstraintKeys other = (ConstraintKeys) obj;
            return
                Objects.deepEquals(constraintId, other.constraintId);
        }
        return false;
    }
}