/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.CustomerTreeFlavors;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.Rp;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of multicast.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultMulticast extends InnerModelObject implements Multicast {
    protected boolean enabled;
    protected BitSet valueLeafFlags = new BitSet();
    protected CustomerTreeFlavors customerTreeFlavors;
    protected Rp rp;

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public CustomerTreeFlavors customerTreeFlavors() {
        return customerTreeFlavors;
    }

    @Override
    public Rp rp() {
        return rp;
    }

    @Override
    public void enabled(boolean enabled) {
        valueLeafFlags.set(LeafIdentifier.ENABLED.getLeafIndex());
        this.enabled = enabled;
    }

    @Override
    public void customerTreeFlavors(CustomerTreeFlavors customerTreeFlavors) {
        this.customerTreeFlavors = customerTreeFlavors;
    }

    @Override
    public void rp(Rp rp) {
        this.rp = rp;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enabled, valueLeafFlags, customerTreeFlavors, rp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMulticast) {
            DefaultMulticast other = (DefaultMulticast) obj;
            return
                Objects.deepEquals(enabled, other.enabled) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(customerTreeFlavors, other.customerTreeFlavors) &&
                Objects.deepEquals(rp, other.rp);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("enabled=" + enabled)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("customerTreeFlavors=" + customerTreeFlavors)
            .add("rp=" + rp)
            .toString();
    }


    /**
     * Creates an instance of defaultMulticast.
     */
    public DefaultMulticast() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}