/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.RpDiscovery;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.RpGroupMappings;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of rp.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultRp extends InnerModelObject implements Rp {
    protected RpGroupMappings rpGroupMappings;
    protected RpDiscovery rpDiscovery;

    @Override
    public RpGroupMappings rpGroupMappings() {
        return rpGroupMappings;
    }

    @Override
    public RpDiscovery rpDiscovery() {
        return rpDiscovery;
    }

    @Override
    public void rpGroupMappings(RpGroupMappings rpGroupMappings) {
        this.rpGroupMappings = rpGroupMappings;
    }

    @Override
    public void rpDiscovery(RpDiscovery rpDiscovery) {
        this.rpDiscovery = rpDiscovery;
    }

    @Override
    public int hashCode() {
        return Objects.hash(rpGroupMappings, rpDiscovery);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRp) {
            DefaultRp other = (DefaultRp) obj;
            return
                Objects.deepEquals(rpGroupMappings, other.rpGroupMappings) &&
                Objects.deepEquals(rpDiscovery, other.rpDiscovery);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("rpGroupMappings=" + rpGroupMappings)
            .add("rpDiscovery=" + rpDiscovery)
            .toString();
    }


    /**
     * Creates an instance of defaultRp.
     */
    public DefaultRp() {
    }

}