/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.customertreeflavors;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.MulticastTreeType;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of treeFlavor.
 */
public class TreeFlavorKeys implements KeyInfo<DefaultTreeFlavor> {
    protected Class<? extends MulticastTreeType> type;
    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    public Class<? extends MulticastTreeType> type() {
        return type;
    }

    /**
     * Sets the value to attribute type.
     *
     * @param type value of type
     */
    public void type(Class<? extends MulticastTreeType> type) {
        this.type = type;
    }


    @Override
    public int hashCode() {
        return Objects.hash(type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TreeFlavorKeys) {
            TreeFlavorKeys other = (TreeFlavorKeys) obj;
            return
                Objects.deepEquals(type, other.type);
        }
        return false;
    }
}