/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bfdgrouping.holdtime.dynamic;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of dynamicValue.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultDynamicValue extends InnerModelObject implements DynamicValue {
    protected int interval;
    protected int multiplier;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public int interval() {
        return interval;
    }

    @Override
    public int multiplier() {
        return multiplier;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void interval(int interval) {
        valueLeafFlags.set(LeafIdentifier.INTERVAL.getLeafIndex());
        this.interval = interval;
    }

    @Override
    public void multiplier(int multiplier) {
        valueLeafFlags.set(LeafIdentifier.MULTIPLIER.getLeafIndex());
        this.multiplier = multiplier;
    }

    @Override
    public int hashCode() {
        return Objects.hash(interval, multiplier, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDynamicValue) {
            DefaultDynamicValue other = (DefaultDynamicValue) obj;
            return
                Objects.deepEquals(interval, other.interval) &&
                Objects.deepEquals(multiplier, other.multiplier) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("interval=" + interval)
            .add("multiplier=" + multiplier)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultDynamicValue.
     */
    public DefaultDynamicValue() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}