/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.service.qos.qosprofile.qosprofile.augmentedl3vpnqosprofile.customunicom;

import java.util.List;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.classprofile.QosClass;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of outboundClasses.
 */
public interface OutboundClasses extends Augmentable  {

    /**
     * Returns the attribute qosClass.
     *
     * @return qosClass list of qosClass
     */
    List<QosClass> qosClass();

    /**
     * Sets the attribute qosClass.
     *
     * @param qosClass list of qosClass
     */
    void qosClass(List<QosClass> qosClass);

    /**
     * Adds to the list of qosClass.
     *
     * @param addTo value of qosClass
     */
    void addToQosClass(QosClass addTo);

}