/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedatainterfile.rev20160826.modeldatatoresourcedatainterfile.firstlevel.containerchoice.choicecase.leafcase;

import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedSchLeafCase.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedSchLeafCase extends InnerModelObject implements AugmentedSchLeafCase {
    protected BigDecimal leafInterAug;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public BigDecimal leafInterAug() {
        return leafInterAug;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leafInterAug(BigDecimal leafInterAug) {
        valueLeafFlags.set(LeafIdentifier.LEAFINTERAUG.getLeafIndex());
        this.leafInterAug = leafInterAug;
    }

    @Override
    public int hashCode() {
        return Objects.hash(leafInterAug, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedSchLeafCase) {
            DefaultAugmentedSchLeafCase other = (DefaultAugmentedSchLeafCase) obj;
            return
                Objects.deepEquals(leafInterAug, other.leafInterAug) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leafInterAug=" + leafInterAug)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedSchLeafCase.
     */
    public DefaultAugmentedSchLeafCase() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}