/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type.Con1;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type.Leaf1Union;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type.Leaf6Enum;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of type.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultType extends InnerModelObject 
        implements Type, MultiInstanceObject<TypeKeys> {
    protected Leaf1Union leaf1;
    protected Class<? extends YangAutoPrefixInt> leaf2;
    protected Tdef1 leaf3;
    protected Class<? extends YangAutoPrefixInt> leaf4;
    protected String leaf5;
    protected Leaf6Enum leaf6;
    protected Bitdef leaf7;
    protected byte[] leaf8;
    protected Id leaf9;
    protected BitSet valueLeafFlags = new BitSet();
    protected Con1 con1;

    @Override
    public Leaf1Union leaf1() {
        return leaf1;
    }

    @Override
    public Class<? extends YangAutoPrefixInt> leaf2() {
        return leaf2;
    }

    @Override
    public Tdef1 leaf3() {
        return leaf3;
    }

    @Override
    public Class<? extends YangAutoPrefixInt> leaf4() {
        return leaf4;
    }

    @Override
    public String leaf5() {
        return leaf5;
    }

    @Override
    public Leaf6Enum leaf6() {
        return leaf6;
    }

    @Override
    public Bitdef leaf7() {
        return leaf7;
    }

    @Override
    public byte[] leaf8() {
        return leaf8;
    }

    @Override
    public Id leaf9() {
        return leaf9;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Con1 con1() {
        return con1;
    }

    @Override
    public void leaf1(Leaf1Union leaf1) {
        valueLeafFlags.set(LeafIdentifier.LEAF1.getLeafIndex());
        this.leaf1 = leaf1;
    }

    @Override
    public void leaf2(Class<? extends YangAutoPrefixInt> leaf2) {
        valueLeafFlags.set(LeafIdentifier.LEAF2.getLeafIndex());
        this.leaf2 = leaf2;
    }

    @Override
    public void leaf3(Tdef1 leaf3) {
        valueLeafFlags.set(LeafIdentifier.LEAF3.getLeafIndex());
        this.leaf3 = leaf3;
    }

    @Override
    public void leaf4(Class<? extends YangAutoPrefixInt> leaf4) {
        valueLeafFlags.set(LeafIdentifier.LEAF4.getLeafIndex());
        this.leaf4 = leaf4;
    }

    @Override
    public void leaf5(String leaf5) {
        valueLeafFlags.set(LeafIdentifier.LEAF5.getLeafIndex());
        this.leaf5 = leaf5;
    }

    @Override
    public void leaf6(Leaf6Enum leaf6) {
        valueLeafFlags.set(LeafIdentifier.LEAF6.getLeafIndex());
        this.leaf6 = leaf6;
    }

    @Override
    public void leaf7(Bitdef leaf7) {
        valueLeafFlags.set(LeafIdentifier.LEAF7.getLeafIndex());
        this.leaf7 = leaf7;
    }

    @Override
    public void leaf8(byte[] leaf8) {
        valueLeafFlags.set(LeafIdentifier.LEAF8.getLeafIndex());
        this.leaf8 = leaf8;
    }

    @Override
    public void leaf9(Id leaf9) {
        valueLeafFlags.set(LeafIdentifier.LEAF9.getLeafIndex());
        this.leaf9 = leaf9;
    }

    @Override
    public void con1(Con1 con1) {
        this.con1 = con1;
    }

    @Override
    public int hashCode() {
        return Objects.hash(leaf1, leaf2, leaf3, leaf4, leaf5, leaf6, leaf7, leaf8, leaf9, valueLeafFlags, con1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultType) {
            DefaultType other = (DefaultType) obj;
            return
                Objects.deepEquals(leaf1, other.leaf1) &&
                Objects.deepEquals(leaf2, other.leaf2) &&
                Objects.deepEquals(leaf3, other.leaf3) &&
                Objects.deepEquals(leaf4, other.leaf4) &&
                Objects.deepEquals(leaf5, other.leaf5) &&
                Objects.deepEquals(leaf6, other.leaf6) &&
                Objects.deepEquals(leaf7, other.leaf7) &&
                Objects.deepEquals(leaf8, other.leaf8) &&
                Objects.deepEquals(leaf9, other.leaf9) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(con1, other.con1);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf1=" + leaf1)
            .add("leaf2=" + leaf2)
            .add("leaf3=" + leaf3)
            .add("leaf4=" + leaf4)
            .add("leaf5=" + leaf5)
            .add("leaf6=" + leaf6)
            .add("leaf7=" + leaf7)
            .add("leaf8=" + leaf8)
            .add("leaf9=" + leaf9)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("con1=" + con1)
            .toString();
    }


    /**
     * Creates an instance of defaultType.
     */
    public DefaultType() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}