/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey;

import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.id.IdUnion;
import java.util.Objects;

/**
 * Represents the implementation of id.
 */
public final class Id {

    private IdUnion union;

    /**
     * Creates an instance of id.
     */
    private Id() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public Id(IdUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of id for type union.
     *
     * @param value value of id for type union
     * @return id for type union
     */
    public static Id of(IdUnion value) {
        return new Id(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public IdUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(IdUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Id) {
            Id other = (Id) obj;
            return
                Objects.deepEquals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of id fromString input String id.
     *
     * @param valInString value of input String
     * @return id
     */
    public static Id fromString(String valInString) {
        try {
            IdUnion tmpVal = IdUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
