/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.id;

import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Phy;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Vir;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.YangAutoPrefixInt;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of idUnion.
 */
public final class IdUnion {
    private Class<? extends YangAutoPrefixInt> identityref;
    private boolean yangAutoPrefixBoolean;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of idUnion.
     */
    private IdUnion() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public IdUnion(Class<? extends YangAutoPrefixInt> identityref) {
        setValue.set(0);
        this.identityref = identityref;
    }

    /**
     * Creates an instance of yangAutoPrefixBoolean.
     *
     * @param yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public IdUnion(boolean yangAutoPrefixBoolean) {
        setValue.set(1);
        this.yangAutoPrefixBoolean = yangAutoPrefixBoolean;
    }

    /**
     * Returns the object of idUnion for type identityref.
     *
     * @param value value of idUnion for type identityref
     * @return idUnion for type identityref
     */
    public static IdUnion of(Class<? extends YangAutoPrefixInt> value) {
        return new IdUnion(value);
    }

    /**
     * Returns the object of idUnion for type yangAutoPrefixBoolean.
     *
     * @param value value of idUnion for type yangAutoPrefixBoolean
     * @return idUnion for type yangAutoPrefixBoolean
     */
    public static IdUnion of(boolean value) {
        return new IdUnion(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends YangAutoPrefixInt> identityref() {
        return identityref;
    }
    /**
     * Returns the attribute yangAutoPrefixBoolean.
     *
     * @return yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public boolean yangAutoPrefixBoolean() {
        return yangAutoPrefixBoolean;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends YangAutoPrefixInt> identityref) {
        this.identityref = identityref;
    }
    /**
     * Sets the attribute yangAutoPrefixBoolean.
     *
     * @param yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public void yangAutoPrefixBoolean(boolean yangAutoPrefixBoolean) {
        this.yangAutoPrefixBoolean = yangAutoPrefixBoolean;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref, yangAutoPrefixBoolean);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IdUnion) {
            IdUnion other = (IdUnion) obj;
            return
                Objects.deepEquals(identityref, other.identityref) &&
                Objects.deepEquals(yangAutoPrefixBoolean, other.yangAutoPrefixBoolean);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            if (identityref.equals(YangAutoPrefixInt.class)) {
                return YangAutoPrefixInt.yangAutoPrefixIntToString();
            } else if (identityref.equals(Phy.class)) {
                return Phy.phyToString();
            } else if (identityref.equals(Vir.class)) {
                return Vir.virToString();
            }
        }
        if (setValue.get(1)) {
            return yangAutoPrefixBoolean ? "true" : "false";
        }
        return null;
    }
    /**
     * Returns the object of idUnion fromString input String idUnion.
     *
     * @param valInString value of input String
     * @return idUnion
     */
    public static IdUnion fromString(String valInString) {
        try {
            Class<? extends YangAutoPrefixInt> tmpVal = YangAutoPrefixInt.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            boolean tmpVal = Boolean.parseBoolean(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
