/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Tdef1;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of con1.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCon1 extends InnerModelObject implements Con1 {
    protected List<Tdef1> ll;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<Tdef1> ll() {
        return ll;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void ll(List<Tdef1> ll) {
        valueLeafFlags.set(LeafIdentifier.LL.getLeafIndex());
        this.ll = ll;
    }

    @Override
    public void addToLl(Tdef1 addTo) {
        if (ll == null) {
            ll = new ArrayList<>();
        }
        ll.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(ll, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCon1) {
            DefaultCon1 other = (DefaultCon1) obj;
            return
                Objects.deepEquals(ll, other.ll) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("ll=" + ll)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultCon1.
     */
    public DefaultCon1() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}