/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont;

/**
 * Represents ENUM data of lfenumEnum.
 */
public enum LfenumEnum {

    /**
     * Represents yangAutoPrefix3.3ms.
     */
    YANGAUTOPREFIX3_3MS(0, "3.3ms"),

    /**
     * Represents enum2.
     */
    ENUM2(1, "enum2"),

    /**
     * Represents enum3.
     */
    ENUM3(2, "enum3"),

    /**
     * Represents enum4.
     */
    ENUM4(3, "enum4");

    private int lfenumEnum;
    private String schemaName;

    /**
     * Creates an instance of lfenumEnum.
     *
     * @param lfenumEnum value of lfenumEnum
     */
     LfenumEnum(int lfenumEnum, String schemaName) {
        this.lfenumEnum = lfenumEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of lfenumEnum for.
     *
     * @param value value of lfenumEnum for
     * @return lfenumEnum for
     */
    public static LfenumEnum of(int value) {
        switch (value) {
            case 0:
                return LfenumEnum.YANGAUTOPREFIX3_3MS;
            case 1:
                return LfenumEnum.ENUM2;
            case 2:
                return LfenumEnum.ENUM3;
            case 3:
                return LfenumEnum.ENUM4;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of lfenumEnum for.
     *
     * @param value value of lfenumEnum for
     * @return lfenumEnum for
     */
    public static LfenumEnum of(String value) {
        switch (value) {
            case "3.3ms":
                return LfenumEnum.YANGAUTOPREFIX3_3MS;
            case "enum2":
                return LfenumEnum.ENUM2;
            case "enum3":
                return LfenumEnum.ENUM3;
            case "enum4":
                return LfenumEnum.ENUM4;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute lfenumEnum.
     *
     * @return lfenumEnum value of lfenumEnum
     */
    public int lfenumEnum() {
        return lfenumEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
