/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.gr;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.Iden;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Type;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of cont3.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCont3 extends InnerModelObject implements Cont3 {
    protected Object lref21;
    protected Class<? extends Iden> iref1;
    protected Class<? extends Type> iref3;
    protected List<Object> llref1;
    protected List<Object> llref2;
    protected List<Object> llref3;
    protected List<Object> llref4;
    protected List<Object> llref5;
    protected List<Object> llref6;
    protected List<Object> llref7;
    protected List<Object> llref8;
    protected List<Object> llref9;
    protected List<Object> llref10;
    protected List<Object> llref11;
    protected List<Object> llref12;
    protected List<Object> llref13;
    protected List<Object> llref14;
    protected List<Object> llref15;
    protected List<Object> llref16;
    protected List<Object> llref17;
    protected List<Object> llref18;
    protected List<Object> llref19;
    protected List<Object> llref20;
    protected List<Class<? extends Iden>> iref2;
    protected List<Class<? extends Type>> iref4;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Object lref21() {
        return lref21;
    }

    @Override
    public Class<? extends Iden> iref1() {
        return iref1;
    }

    @Override
    public Class<? extends Type> iref3() {
        return iref3;
    }

    @Override
    public List<Object> llref1() {
        return llref1;
    }

    @Override
    public List<Object> llref2() {
        return llref2;
    }

    @Override
    public List<Object> llref3() {
        return llref3;
    }

    @Override
    public List<Object> llref4() {
        return llref4;
    }

    @Override
    public List<Object> llref5() {
        return llref5;
    }

    @Override
    public List<Object> llref6() {
        return llref6;
    }

    @Override
    public List<Object> llref7() {
        return llref7;
    }

    @Override
    public List<Object> llref8() {
        return llref8;
    }

    @Override
    public List<Object> llref9() {
        return llref9;
    }

    @Override
    public List<Object> llref10() {
        return llref10;
    }

    @Override
    public List<Object> llref11() {
        return llref11;
    }

    @Override
    public List<Object> llref12() {
        return llref12;
    }

    @Override
    public List<Object> llref13() {
        return llref13;
    }

    @Override
    public List<Object> llref14() {
        return llref14;
    }

    @Override
    public List<Object> llref15() {
        return llref15;
    }

    @Override
    public List<Object> llref16() {
        return llref16;
    }

    @Override
    public List<Object> llref17() {
        return llref17;
    }

    @Override
    public List<Object> llref18() {
        return llref18;
    }

    @Override
    public List<Object> llref19() {
        return llref19;
    }

    @Override
    public List<Object> llref20() {
        return llref20;
    }

    @Override
    public List<Class<? extends Iden>> iref2() {
        return iref2;
    }

    @Override
    public List<Class<? extends Type>> iref4() {
        return iref4;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void lref21(Object lref21) {
        valueLeafFlags.set(LeafIdentifier.LREF21.getLeafIndex());
        this.lref21 = lref21;
    }

    @Override
    public void iref1(Class<? extends Iden> iref1) {
        valueLeafFlags.set(LeafIdentifier.IREF1.getLeafIndex());
        this.iref1 = iref1;
    }

    @Override
    public void iref3(Class<? extends Type> iref3) {
        valueLeafFlags.set(LeafIdentifier.IREF3.getLeafIndex());
        this.iref3 = iref3;
    }

    @Override
    public void llref1(List<Object> llref1) {
        valueLeafFlags.set(LeafIdentifier.LLREF1.getLeafIndex());
        this.llref1 = llref1;
    }

    @Override
    public void llref2(List<Object> llref2) {
        valueLeafFlags.set(LeafIdentifier.LLREF2.getLeafIndex());
        this.llref2 = llref2;
    }

    @Override
    public void llref3(List<Object> llref3) {
        valueLeafFlags.set(LeafIdentifier.LLREF3.getLeafIndex());
        this.llref3 = llref3;
    }

    @Override
    public void llref4(List<Object> llref4) {
        valueLeafFlags.set(LeafIdentifier.LLREF4.getLeafIndex());
        this.llref4 = llref4;
    }

    @Override
    public void llref5(List<Object> llref5) {
        valueLeafFlags.set(LeafIdentifier.LLREF5.getLeafIndex());
        this.llref5 = llref5;
    }

    @Override
    public void llref6(List<Object> llref6) {
        valueLeafFlags.set(LeafIdentifier.LLREF6.getLeafIndex());
        this.llref6 = llref6;
    }

    @Override
    public void llref7(List<Object> llref7) {
        valueLeafFlags.set(LeafIdentifier.LLREF7.getLeafIndex());
        this.llref7 = llref7;
    }

    @Override
    public void llref8(List<Object> llref8) {
        valueLeafFlags.set(LeafIdentifier.LLREF8.getLeafIndex());
        this.llref8 = llref8;
    }

    @Override
    public void llref9(List<Object> llref9) {
        valueLeafFlags.set(LeafIdentifier.LLREF9.getLeafIndex());
        this.llref9 = llref9;
    }

    @Override
    public void llref10(List<Object> llref10) {
        valueLeafFlags.set(LeafIdentifier.LLREF10.getLeafIndex());
        this.llref10 = llref10;
    }

    @Override
    public void llref11(List<Object> llref11) {
        valueLeafFlags.set(LeafIdentifier.LLREF11.getLeafIndex());
        this.llref11 = llref11;
    }

    @Override
    public void llref12(List<Object> llref12) {
        valueLeafFlags.set(LeafIdentifier.LLREF12.getLeafIndex());
        this.llref12 = llref12;
    }

    @Override
    public void llref13(List<Object> llref13) {
        valueLeafFlags.set(LeafIdentifier.LLREF13.getLeafIndex());
        this.llref13 = llref13;
    }

    @Override
    public void llref14(List<Object> llref14) {
        valueLeafFlags.set(LeafIdentifier.LLREF14.getLeafIndex());
        this.llref14 = llref14;
    }

    @Override
    public void llref15(List<Object> llref15) {
        valueLeafFlags.set(LeafIdentifier.LLREF15.getLeafIndex());
        this.llref15 = llref15;
    }

    @Override
    public void llref16(List<Object> llref16) {
        valueLeafFlags.set(LeafIdentifier.LLREF16.getLeafIndex());
        this.llref16 = llref16;
    }

    @Override
    public void llref17(List<Object> llref17) {
        valueLeafFlags.set(LeafIdentifier.LLREF17.getLeafIndex());
        this.llref17 = llref17;
    }

    @Override
    public void llref18(List<Object> llref18) {
        valueLeafFlags.set(LeafIdentifier.LLREF18.getLeafIndex());
        this.llref18 = llref18;
    }

    @Override
    public void llref19(List<Object> llref19) {
        valueLeafFlags.set(LeafIdentifier.LLREF19.getLeafIndex());
        this.llref19 = llref19;
    }

    @Override
    public void llref20(List<Object> llref20) {
        valueLeafFlags.set(LeafIdentifier.LLREF20.getLeafIndex());
        this.llref20 = llref20;
    }

    @Override
    public void iref2(List<Class<? extends Iden>> iref2) {
        valueLeafFlags.set(LeafIdentifier.IREF2.getLeafIndex());
        this.iref2 = iref2;
    }

    @Override
    public void iref4(List<Class<? extends Type>> iref4) {
        valueLeafFlags.set(LeafIdentifier.IREF4.getLeafIndex());
        this.iref4 = iref4;
    }

    @Override
    public void addToLlref1(Object addTo) {
        if (llref1 == null) {
            llref1 = new ArrayList<>();
        }
        llref1.add(addTo);
    }


    @Override
    public void addToLlref2(Object addTo) {
        if (llref2 == null) {
            llref2 = new ArrayList<>();
        }
        llref2.add(addTo);
    }


    @Override
    public void addToLlref3(Object addTo) {
        if (llref3 == null) {
            llref3 = new ArrayList<>();
        }
        llref3.add(addTo);
    }


    @Override
    public void addToLlref4(Object addTo) {
        if (llref4 == null) {
            llref4 = new ArrayList<>();
        }
        llref4.add(addTo);
    }


    @Override
    public void addToLlref5(Object addTo) {
        if (llref5 == null) {
            llref5 = new ArrayList<>();
        }
        llref5.add(addTo);
    }


    @Override
    public void addToLlref6(Object addTo) {
        if (llref6 == null) {
            llref6 = new ArrayList<>();
        }
        llref6.add(addTo);
    }


    @Override
    public void addToLlref7(Object addTo) {
        if (llref7 == null) {
            llref7 = new ArrayList<>();
        }
        llref7.add(addTo);
    }


    @Override
    public void addToLlref8(Object addTo) {
        if (llref8 == null) {
            llref8 = new ArrayList<>();
        }
        llref8.add(addTo);
    }


    @Override
    public void addToLlref9(Object addTo) {
        if (llref9 == null) {
            llref9 = new ArrayList<>();
        }
        llref9.add(addTo);
    }


    @Override
    public void addToLlref10(Object addTo) {
        if (llref10 == null) {
            llref10 = new ArrayList<>();
        }
        llref10.add(addTo);
    }


    @Override
    public void addToLlref11(Object addTo) {
        if (llref11 == null) {
            llref11 = new ArrayList<>();
        }
        llref11.add(addTo);
    }


    @Override
    public void addToLlref12(Object addTo) {
        if (llref12 == null) {
            llref12 = new ArrayList<>();
        }
        llref12.add(addTo);
    }


    @Override
    public void addToLlref13(Object addTo) {
        if (llref13 == null) {
            llref13 = new ArrayList<>();
        }
        llref13.add(addTo);
    }


    @Override
    public void addToLlref14(Object addTo) {
        if (llref14 == null) {
            llref14 = new ArrayList<>();
        }
        llref14.add(addTo);
    }


    @Override
    public void addToLlref15(Object addTo) {
        if (llref15 == null) {
            llref15 = new ArrayList<>();
        }
        llref15.add(addTo);
    }


    @Override
    public void addToLlref16(Object addTo) {
        if (llref16 == null) {
            llref16 = new ArrayList<>();
        }
        llref16.add(addTo);
    }


    @Override
    public void addToLlref17(Object addTo) {
        if (llref17 == null) {
            llref17 = new ArrayList<>();
        }
        llref17.add(addTo);
    }


    @Override
    public void addToLlref18(Object addTo) {
        if (llref18 == null) {
            llref18 = new ArrayList<>();
        }
        llref18.add(addTo);
    }


    @Override
    public void addToLlref19(Object addTo) {
        if (llref19 == null) {
            llref19 = new ArrayList<>();
        }
        llref19.add(addTo);
    }


    @Override
    public void addToLlref20(Object addTo) {
        if (llref20 == null) {
            llref20 = new ArrayList<>();
        }
        llref20.add(addTo);
    }


    @Override
    public void addToIref2(Class<? extends Iden> addTo) {
        if (iref2 == null) {
            iref2 = new ArrayList<>();
        }
        iref2.add(addTo);
    }


    @Override
    public void addToIref4(Class<? extends Type> addTo) {
        if (iref4 == null) {
            iref4 = new ArrayList<>();
        }
        iref4.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(lref21, iref1, iref3, llref1, llref2, llref3, llref4, llref5, llref6, llref7, llref8, llref9, llref10, llref11, llref12, llref13, llref14, llref15, llref16, llref17, llref18, llref19, llref20, iref2, iref4, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCont3) {
            DefaultCont3 other = (DefaultCont3) obj;
            return
                Objects.deepEquals(lref21, other.lref21) &&
                Objects.deepEquals(iref1, other.iref1) &&
                Objects.deepEquals(iref3, other.iref3) &&
                Objects.deepEquals(llref1, other.llref1) &&
                Objects.deepEquals(llref2, other.llref2) &&
                Objects.deepEquals(llref3, other.llref3) &&
                Objects.deepEquals(llref4, other.llref4) &&
                Objects.deepEquals(llref5, other.llref5) &&
                Objects.deepEquals(llref6, other.llref6) &&
                Objects.deepEquals(llref7, other.llref7) &&
                Objects.deepEquals(llref8, other.llref8) &&
                Objects.deepEquals(llref9, other.llref9) &&
                Objects.deepEquals(llref10, other.llref10) &&
                Objects.deepEquals(llref11, other.llref11) &&
                Objects.deepEquals(llref12, other.llref12) &&
                Objects.deepEquals(llref13, other.llref13) &&
                Objects.deepEquals(llref14, other.llref14) &&
                Objects.deepEquals(llref15, other.llref15) &&
                Objects.deepEquals(llref16, other.llref16) &&
                Objects.deepEquals(llref17, other.llref17) &&
                Objects.deepEquals(llref18, other.llref18) &&
                Objects.deepEquals(llref19, other.llref19) &&
                Objects.deepEquals(llref20, other.llref20) &&
                Objects.deepEquals(iref2, other.iref2) &&
                Objects.deepEquals(iref4, other.iref4) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("lref21=" + lref21)
            .add("iref1=" + iref1)
            .add("iref3=" + iref3)
            .add("llref1=" + llref1)
            .add("llref2=" + llref2)
            .add("llref3=" + llref3)
            .add("llref4=" + llref4)
            .add("llref5=" + llref5)
            .add("llref6=" + llref6)
            .add("llref7=" + llref7)
            .add("llref8=" + llref8)
            .add("llref9=" + llref9)
            .add("llref10=" + llref10)
            .add("llref11=" + llref11)
            .add("llref12=" + llref12)
            .add("llref13=" + llref13)
            .add("llref14=" + llref14)
            .add("llref15=" + llref15)
            .add("llref16=" + llref16)
            .add("llref17=" + llref17)
            .add("llref18=" + llref18)
            .add("llref19=" + llref19)
            .add("llref20=" + llref20)
            .add("iref2=" + iref2)
            .add("iref4=" + iref4)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultCont3.
     */
    public DefaultCont3() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}