/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1;

/**
 * Represents ENUM data of lfenum1Enum.
 */
public enum Lfenum1Enum {

    /**
     * Represents successful exit.
     */
    SUCCESSFUL_EXIT(1, "successful exit"),

    /**
     * Represents grace period expired.
     */
    GRACE_PERIOD_EXPIRED(2, "grace period expired");

    private int lfenum1Enum;
    private String schemaName;

    /**
     * Creates an instance of lfenum1Enum.
     *
     * @param lfenum1Enum value of lfenum1Enum
     */
     Lfenum1Enum(int lfenum1Enum, String schemaName) {
        this.lfenum1Enum = lfenum1Enum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of lfenum1Enum for.
     *
     * @param value value of lfenum1Enum for
     * @return lfenum1Enum for
     */
    public static Lfenum1Enum of(int value) {
        switch (value) {
            case 1:
                return Lfenum1Enum.SUCCESSFUL_EXIT;
            case 2:
                return Lfenum1Enum.GRACE_PERIOD_EXPIRED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of lfenum1Enum for.
     *
     * @param value value of lfenum1Enum for
     * @return lfenum1Enum for
     */
    public static Lfenum1Enum of(String value) {
        switch (value) {
            case "successful exit":
                return Lfenum1Enum.SUCCESSFUL_EXIT;
            case "grace period expired":
                return Lfenum1Enum.GRACE_PERIOD_EXPIRED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute lfenum1Enum.
     *
     * @return lfenum1Enum value of lfenum1Enum
     */
    public int lfenum1Enum() {
        return lfenum1Enum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
