/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1;

/**
 * Represents ENUM data of lfenum2Enum.
 */
public enum Lfenum2Enum {

    /**
     * Represents successful exit.
     */
    SUCCESSFUL_EXIT(1, "successful exit"),

    /**
     * Represents *.
     */
    ASTERISK(3, "*");

    private int lfenum2Enum;
    private String schemaName;

    /**
     * Creates an instance of lfenum2Enum.
     *
     * @param lfenum2Enum value of lfenum2Enum
     */
     Lfenum2Enum(int lfenum2Enum, String schemaName) {
        this.lfenum2Enum = lfenum2Enum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of lfenum2Enum for.
     *
     * @param value value of lfenum2Enum for
     * @return lfenum2Enum for
     */
    public static Lfenum2Enum of(int value) {
        switch (value) {
            case 1:
                return Lfenum2Enum.SUCCESSFUL_EXIT;
            case 3:
                return Lfenum2Enum.ASTERISK;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of lfenum2Enum for.
     *
     * @param value value of lfenum2Enum for
     * @return lfenum2Enum for
     */
    public static Lfenum2Enum of(String value) {
        switch (value) {
            case "successful exit":
                return Lfenum2Enum.SUCCESSFUL_EXIT;
            case "*":
                return Lfenum2Enum.ASTERISK;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute lfenum2Enum.
     *
     * @return lfenum2Enum value of lfenum2Enum
     */
    public int lfenum2Enum() {
        return lfenum2Enum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
