/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.lfunion10union.Bits;
import java.util.Objects;

/**
 * Represents the implementation of lfunion10Union.
 */
public final class Lfunion10Union {
    private BitSet bits;
    private boolean yangAutoPrefixBoolean;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of lfunion10Union.
     */
    private Lfunion10Union() {
    }

    /**
     * Creates an instance of bits.
     *
     * @param bits value of bits
     */
    public Lfunion10Union(BitSet bits) {
        setValue.set(0);
        this.bits = bits;
    }

    /**
     * Creates an instance of yangAutoPrefixBoolean.
     *
     * @param yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public Lfunion10Union(boolean yangAutoPrefixBoolean) {
        setValue.set(1);
        this.yangAutoPrefixBoolean = yangAutoPrefixBoolean;
    }

    /**
     * Returns the object of lfunion10Union for type bits.
     *
     * @param value value of lfunion10Union for type bits
     * @return lfunion10Union for type bits
     */
    public static Lfunion10Union of(BitSet value) {
        return new Lfunion10Union(value);
    }

    /**
     * Returns the object of lfunion10Union for type yangAutoPrefixBoolean.
     *
     * @param value value of lfunion10Union for type yangAutoPrefixBoolean
     * @return lfunion10Union for type yangAutoPrefixBoolean
     */
    public static Lfunion10Union of(boolean value) {
        return new Lfunion10Union(value);
    }

    /**
     * Returns the attribute bits.
     *
     * @return bits value of bits
     */
    public BitSet bits() {
        return bits;
    }
    /**
     * Returns the attribute yangAutoPrefixBoolean.
     *
     * @return yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public boolean yangAutoPrefixBoolean() {
        return yangAutoPrefixBoolean;
    }
    /**
     * Sets the attribute bits.
     *
     * @param bits value of bits
     */
    public void bits(BitSet bits) {
        this.bits = bits;
    }
    /**
     * Sets the attribute yangAutoPrefixBoolean.
     *
     * @param yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public void yangAutoPrefixBoolean(boolean yangAutoPrefixBoolean) {
        this.yangAutoPrefixBoolean = yangAutoPrefixBoolean;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bits, yangAutoPrefixBoolean);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Lfunion10Union) {
            Lfunion10Union other = (Lfunion10Union) obj;
            return
                Objects.deepEquals(bits, other.bits) &&
                Objects.deepEquals(yangAutoPrefixBoolean, other.yangAutoPrefixBoolean);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return Bits.toString(bits);
        }
        if (setValue.get(1)) {
            return yangAutoPrefixBoolean ? "true" : "false";
        }
        return null;
    }
    /**
     * Returns the object of lfunion10Union fromString input String lfunion10Union.
     *
     * @param valInString value of input String
     * @return lfunion10Union
     */
    public static Lfunion10Union fromString(String valInString) {
        try {
            BitSet tmpVal = Bits.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            boolean tmpVal = Boolean.parseBoolean(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
