/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymsiptopology.rev20140101.ymsiptopology.node;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.ymsiptopology.rev20140101.ymsiptopology.node.augmentedtoponode.AugRoute;
import org.onosproject.yang.gen.v1.ymsiptopology.rev20140101.ymsiptopology.node.augmentedtoponode.AugRoutec;

/**
 * Abstraction of an entity which represents the functionality of augmentedTopoNode.
 */
public interface AugmentedTopoNode {

    /**
     * Identify the leaf of AugmentedTopoNode.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents routerId.
         */
        ROUTERID(1),
        /**
         * Represents routerIp.
         */
        ROUTERIP(2),
        /**
         * Represents routerPath.
         */
        ROUTERPATH(3),
        /**
         * Represents value.
         */
        VALUE(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute routerId.
     *
     * @return routerId value of routerId
     */
    String routerId();

    /**
     * Returns the attribute routerIp.
     *
     * @return routerIp value of routerIp
     */
    String routerIp();

    /**
     * Returns the attribute routerPath.
     *
     * @return routerPath value of routerPath
     */
    String routerPath();

    /**
     * Returns the attribute value.
     *
     * @return value list of value
     */
    List<Short> value();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute augRoute.
     *
     * @return augRoute value of augRoute
     */
    AugRoute augRoute();

    /**
     * Returns the attribute augRoutec.
     *
     * @return augRoutec list of augRoutec
     */
    List<AugRoutec> augRoutec();

    /**
     * Sets the attribute routerId.
     *
     * @param routerId value of routerId
     */
    void routerId(String routerId);

    /**
     * Sets the attribute routerIp.
     *
     * @param routerIp value of routerIp
     */
    void routerIp(String routerIp);

    /**
     * Sets the attribute routerPath.
     *
     * @param routerPath value of routerPath
     */
    void routerPath(String routerPath);

    /**
     * Sets the attribute value.
     *
     * @param value list of value
     */
    void value(List<Short> value);

    /**
     * Sets the attribute augRoute.
     *
     * @param augRoute value of augRoute
     */
    void augRoute(AugRoute augRoute);

    /**
     * Sets the attribute augRoutec.
     *
     * @param augRoutec list of augRoutec
     */
    void augRoutec(List<AugRoutec> augRoutec);

    /**
     * Adds to the list of value.
     *
     * @param addTo value of value
     */
    void addToValue(Short addTo);

    /**
     * Adds to the list of augRoutec.
     *
     * @param addTo value of augRoutec
     */
    void addToAugRoutec(AugRoutec addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}