/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.Choice1;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.TerminationPoints;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of node.
 */
public interface Node extends Augmentable  {

    /**
     * Identify the leaf of Node.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents nodeId.
         */
        NODEID(1),
        /**
         * Represents nodeProp.
         */
        NODEPROP(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute nodeId.
     *
     * @return nodeId value of nodeId
     */
    String nodeId();

    /**
     * Returns the attribute nodeProp.
     *
     * @return nodeProp list of nodeProp
     */
    List<String> nodeProp();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute terminationPoints.
     *
     * @return terminationPoints value of terminationPoints
     */
    TerminationPoints terminationPoints();

    /**
     * Returns the attribute choice1.
     *
     * @return choice1 value of choice1
     */
    Choice1 choice1();

    /**
     * Sets the attribute nodeId.
     *
     * @param nodeId value of nodeId
     */
    void nodeId(String nodeId);

    /**
     * Sets the attribute nodeProp.
     *
     * @param nodeProp list of nodeProp
     */
    void nodeProp(List<String> nodeProp);

    /**
     * Sets the attribute terminationPoints.
     *
     * @param terminationPoints value of terminationPoints
     */
    void terminationPoints(TerminationPoints terminationPoints);

    /**
     * Sets the attribute choice1.
     *
     * @param choice1 value of choice1
     */
    void choice1(Choice1 choice1);

    /**
     * Adds to the list of nodeProp.
     *
     * @param addTo value of nodeProp
     */
    void addToNodeProp(String addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}