/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.Choice2;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of case2a.
 */
public interface Case2a extends Choice2, Augmentable  {

    /**
     * Identify the leaf of Case2a.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf2A1.
         */
        LEAF2A1(1),
        /**
         * Represents leaf2A2.
         */
        LEAF2A2(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf2A1.
     *
     * @return leaf2A1 value of leaf2A1
     */
    String leaf2A1();

    /**
     * Returns the attribute leaf2A2.
     *
     * @return leaf2A2 value of leaf2A2
     */
    String leaf2A2();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute leaf2A1.
     *
     * @param leaf2A1 value of leaf2A1
     */
    void leaf2A1(String leaf2A1);

    /**
     * Sets the attribute leaf2A2.
     *
     * @param leaf2A2 value of leaf2A2
     */
    void leaf2A2(String leaf2A2);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}