/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.Choice2;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2.case2b.Choice3b;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of case2b.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCase2b extends InnerModelObject implements Case2b {
    protected Choice3b choice3b;

    @Override
    public Choice3b choice3b() {
        return choice3b;
    }

    @Override
    public void choice3b(Choice3b choice3b) {
        this.choice3b = choice3b;
    }

    @Override
    public int hashCode() {
        return Objects.hash(choice3b);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCase2b) {
            DefaultCase2b other = (DefaultCase2b) obj;
            return
                Objects.deepEquals(choice3b, other.choice3b);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("choice3b=" + choice3b)
            .toString();
    }


    /**
     * Creates an instance of defaultCase2b.
     */
    public DefaultCase2b() {
    }

}