/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2.case2b.choice3b;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2.case2b.Choice3b;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of case2Bi.
 */
public interface Case2Bi extends Choice3b, Augmentable  {

    /**
     * Identify the leaf of Case2Bi.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf2Bia.
         */
        LEAF2BIA(1),
        /**
         * Represents leaf2Bib.
         */
        LEAF2BIB(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf2Bia.
     *
     * @return leaf2Bia value of leaf2Bia
     */
    String leaf2Bia();

    /**
     * Returns the attribute leaf2Bib.
     *
     * @return leaf2Bib value of leaf2Bib
     */
    String leaf2Bib();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute leaf2Bia.
     *
     * @param leaf2Bia value of leaf2Bia
     */
    void leaf2Bia(String leaf2Bia);

    /**
     * Sets the attribute leaf2Bib.
     *
     * @param leaf2Bib value of leaf2Bib
     */
    void leaf2Bib(String leaf2Bib);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}