/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2.case2b.choice3b;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2.case2b.Choice3b;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of case2Bi.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCase2Bi extends InnerModelObject implements Case2Bi {
    protected String leaf2Bia;
    protected String leaf2Bib;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String leaf2Bia() {
        return leaf2Bia;
    }

    @Override
    public String leaf2Bib() {
        return leaf2Bib;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leaf2Bia(String leaf2Bia) {
        valueLeafFlags.set(LeafIdentifier.LEAF2BIA.getLeafIndex());
        this.leaf2Bia = leaf2Bia;
    }

    @Override
    public void leaf2Bib(String leaf2Bib) {
        valueLeafFlags.set(LeafIdentifier.LEAF2BIB.getLeafIndex());
        this.leaf2Bib = leaf2Bib;
    }

    @Override
    public int hashCode() {
        return Objects.hash(leaf2Bia, leaf2Bib, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCase2Bi) {
            DefaultCase2Bi other = (DefaultCase2Bi) obj;
            return
                Objects.deepEquals(leaf2Bia, other.leaf2Bia) &&
                Objects.deepEquals(leaf2Bib, other.leaf2Bib) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf2Bia=" + leaf2Bia)
            .add("leaf2Bib=" + leaf2Bib)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultCase2Bi.
     */
    public DefaultCase2Bi() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}