/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.choice1;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.Choice1;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of case1a.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCase1a extends InnerModelObject implements Case1a {
    protected String leaf1A1;
    protected String leaf1A2;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String leaf1A1() {
        return leaf1A1;
    }

    @Override
    public String leaf1A2() {
        return leaf1A2;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leaf1A1(String leaf1A1) {
        valueLeafFlags.set(LeafIdentifier.LEAF1A1.getLeafIndex());
        this.leaf1A1 = leaf1A1;
    }

    @Override
    public void leaf1A2(String leaf1A2) {
        valueLeafFlags.set(LeafIdentifier.LEAF1A2.getLeafIndex());
        this.leaf1A2 = leaf1A2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(leaf1A1, leaf1A2, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCase1a) {
            DefaultCase1a other = (DefaultCase1a) obj;
            return
                Objects.deepEquals(leaf1A1, other.leaf1A1) &&
                Objects.deepEquals(leaf1A2, other.leaf1A2) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf1A1=" + leaf1A1)
            .add("leaf1A2=" + leaf1A2)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultCase1a.
     */
    public DefaultCase1a() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}