/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.ipaddress;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv6Address;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of ipAddressUnion.
 */
public final class IpAddressUnion {
    private Ipv4Address ipv4Address;
    private Ipv6Address ipv6Address;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of ipAddressUnion.
     */
    private IpAddressUnion() {
    }

    /**
     * Creates an instance of ipv4Address.
     *
     * @param ipv4Address value of ipv4Address
     */
    public IpAddressUnion(Ipv4Address ipv4Address) {
        setValue.set(0);
        this.ipv4Address = ipv4Address;
    }

    /**
     * Creates an instance of ipv6Address.
     *
     * @param ipv6Address value of ipv6Address
     */
    public IpAddressUnion(Ipv6Address ipv6Address) {
        setValue.set(1);
        this.ipv6Address = ipv6Address;
    }

    /**
     * Returns the object of ipAddressUnion for type ipv4Address.
     *
     * @param value value of ipAddressUnion for type ipv4Address
     * @return ipAddressUnion for type ipv4Address
     */
    public static IpAddressUnion of(Ipv4Address value) {
        return new IpAddressUnion(value);
    }

    /**
     * Returns the object of ipAddressUnion for type ipv6Address.
     *
     * @param value value of ipAddressUnion for type ipv6Address
     * @return ipAddressUnion for type ipv6Address
     */
    public static IpAddressUnion of(Ipv6Address value) {
        return new IpAddressUnion(value);
    }

    /**
     * Returns the attribute ipv4Address.
     *
     * @return ipv4Address value of ipv4Address
     */
    public Ipv4Address ipv4Address() {
        return ipv4Address;
    }
    /**
     * Returns the attribute ipv6Address.
     *
     * @return ipv6Address value of ipv6Address
     */
    public Ipv6Address ipv6Address() {
        return ipv6Address;
    }
    /**
     * Sets the attribute ipv4Address.
     *
     * @param ipv4Address value of ipv4Address
     */
    public void ipv4Address(Ipv4Address ipv4Address) {
        this.ipv4Address = ipv4Address;
    }
    /**
     * Sets the attribute ipv6Address.
     *
     * @param ipv6Address value of ipv6Address
     */
    public void ipv6Address(Ipv6Address ipv6Address) {
        this.ipv6Address = ipv6Address;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ipv4Address, ipv6Address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IpAddressUnion) {
            IpAddressUnion other = (IpAddressUnion) obj;
            return
                Objects.deepEquals(ipv4Address, other.ipv4Address) &&
                Objects.deepEquals(ipv6Address, other.ipv6Address);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return ipv4Address.toString();
        }
        if (setValue.get(1)) {
            return ipv6Address.toString();
        }
        return null;
    }
    /**
     * Returns the object of ipAddressUnion fromString input String ipAddressUnion.
     *
     * @param valInString value of input String
     * @return ipAddressUnion
     */
    public static IpAddressUnion fromString(String valInString) {
        try {
            Ipv4Address tmpVal = Ipv4Address.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Ipv6Address tmpVal = Ipv6Address.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
