/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.Networks;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.NetworksState;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of yrtIetfNetwork.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YrtIetfNetworkOpParam extends InnerModelObject implements YrtIetfNetwork {
    protected Networks networks;
    protected NetworksState networksState;

    @Override
    public Networks networks() {
        return networks;
    }

    @Override
    public NetworksState networksState() {
        return networksState;
    }

    @Override
    public void networks(Networks networks) {
        this.networks = networks;
    }

    @Override
    public void networksState(NetworksState networksState) {
        this.networksState = networksState;
    }

    @Override
    public int hashCode() {
        return Objects.hash(networks, networksState);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YrtIetfNetworkOpParam) {
            YrtIetfNetworkOpParam other = (YrtIetfNetworkOpParam) obj;
            return
                Objects.deepEquals(networks, other.networks) &&
                Objects.deepEquals(networksState, other.networksState);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("networks=" + networks)
            .add("networksState=" + networksState)
            .toString();
    }

    /**
     * Creates an instance of yrtIetfNetworkOpParam.
     */
    public YrtIetfNetworkOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}