/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkaugment.te;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.TeOperStatus;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.BundleStackLevel;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfigattributes.TeLinkAttributes;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkstatederived.AltInformationSources;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkstatederived.Recovery;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkstatederived.Underlay;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of state.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultState extends InnerModelObject implements State {
    protected TeOperStatus operStatus;
    protected InformationSourceEnum informationSource;
    protected List<Object> teLinkTemplate;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<AltInformationSources> altInformationSources;
    protected Recovery recovery;
    protected Underlay underlay;
    protected InformationSourceState informationSourceState;
    protected BundleStackLevel bundleStackLevel;
    protected TeLinkAttributes teLinkAttributes;

    @Override
    public TeOperStatus operStatus() {
        return operStatus;
    }

    @Override
    public InformationSourceEnum informationSource() {
        return informationSource;
    }

    @Override
    public List<Object> teLinkTemplate() {
        return teLinkTemplate;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<AltInformationSources> altInformationSources() {
        return altInformationSources;
    }

    @Override
    public Recovery recovery() {
        return recovery;
    }

    @Override
    public Underlay underlay() {
        return underlay;
    }

    @Override
    public InformationSourceState informationSourceState() {
        return informationSourceState;
    }

    @Override
    public BundleStackLevel bundleStackLevel() {
        return bundleStackLevel;
    }

    @Override
    public TeLinkAttributes teLinkAttributes() {
        return teLinkAttributes;
    }

    @Override
    public void operStatus(TeOperStatus operStatus) {
        valueLeafFlags.set(LeafIdentifier.OPERSTATUS.getLeafIndex());
        this.operStatus = operStatus;
    }

    @Override
    public void informationSource(InformationSourceEnum informationSource) {
        valueLeafFlags.set(LeafIdentifier.INFORMATIONSOURCE.getLeafIndex());
        this.informationSource = informationSource;
    }

    @Override
    public void teLinkTemplate(List<Object> teLinkTemplate) {
        valueLeafFlags.set(LeafIdentifier.TELINKTEMPLATE.getLeafIndex());
        this.teLinkTemplate = teLinkTemplate;
    }

    @Override
    public void altInformationSources(List<AltInformationSources> altInformationSources) {
        this.altInformationSources = altInformationSources;
    }

    @Override
    public void recovery(Recovery recovery) {
        this.recovery = recovery;
    }

    @Override
    public void underlay(Underlay underlay) {
        this.underlay = underlay;
    }

    @Override
    public void informationSourceState(InformationSourceState informationSourceState) {
        this.informationSourceState = informationSourceState;
    }

    @Override
    public void bundleStackLevel(BundleStackLevel bundleStackLevel) {
        this.bundleStackLevel = bundleStackLevel;
    }

    @Override
    public void teLinkAttributes(TeLinkAttributes teLinkAttributes) {
        this.teLinkAttributes = teLinkAttributes;
    }

    @Override
    public void addToTeLinkTemplate(Object addTo) {
        if (teLinkTemplate == null) {
            teLinkTemplate = new ArrayList<>();
        }
        teLinkTemplate.add(addTo);
    }


    @Override
    public void addToAltInformationSources(AltInformationSources addTo) {
        if (altInformationSources == null) {
            altInformationSources = new ArrayList<>();
        }
        altInformationSources.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(operStatus, informationSource, teLinkTemplate, valueLeafFlags, altInformationSources, recovery, underlay, informationSourceState, bundleStackLevel, teLinkAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultState) {
            DefaultState other = (DefaultState) obj;
            return
                Objects.deepEquals(operStatus, other.operStatus) &&
                Objects.deepEquals(informationSource, other.informationSource) &&
                Objects.deepEquals(teLinkTemplate, other.teLinkTemplate) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(altInformationSources, other.altInformationSources) &&
                Objects.deepEquals(recovery, other.recovery) &&
                Objects.deepEquals(underlay, other.underlay) &&
                Objects.deepEquals(informationSourceState, other.informationSourceState) &&
                Objects.deepEquals(bundleStackLevel, other.bundleStackLevel) &&
                Objects.deepEquals(teLinkAttributes, other.teLinkAttributes);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("operStatus=" + operStatus)
            .add("informationSource=" + informationSource)
            .add("teLinkTemplate=" + teLinkTemplate)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("altInformationSources=" + altInformationSources)
            .add("recovery=" + recovery)
            .add("underlay=" + underlay)
            .add("informationSourceState=" + informationSourceState)
            .add("bundleStackLevel=" + bundleStackLevel)
            .add("teLinkAttributes=" + teLinkAttributes)
            .toString();
    }


    /**
     * Creates an instance of defaultState.
     */
    public DefaultState() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}