/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeaugment.te.tunnelterminationpoint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodetunnelterminationcapability.TerminationCapability;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.SwitchingCapabilities;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of state.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultState extends InnerModelObject implements State {
    protected Class<? extends SwitchingCapabilities> switchingCapability;
    protected Class<? extends LspEncodingTypes> encoding;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<TerminationCapability> terminationCapability;

    @Override
    public Class<? extends SwitchingCapabilities> switchingCapability() {
        return switchingCapability;
    }

    @Override
    public Class<? extends LspEncodingTypes> encoding() {
        return encoding;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<TerminationCapability> terminationCapability() {
        return terminationCapability;
    }

    @Override
    public void switchingCapability(Class<? extends SwitchingCapabilities> switchingCapability) {
        valueLeafFlags.set(LeafIdentifier.SWITCHINGCAPABILITY.getLeafIndex());
        this.switchingCapability = switchingCapability;
    }

    @Override
    public void encoding(Class<? extends LspEncodingTypes> encoding) {
        valueLeafFlags.set(LeafIdentifier.ENCODING.getLeafIndex());
        this.encoding = encoding;
    }

    @Override
    public void terminationCapability(List<TerminationCapability> terminationCapability) {
        this.terminationCapability = terminationCapability;
    }

    @Override
    public void addToTerminationCapability(TerminationCapability addTo) {
        if (terminationCapability == null) {
            terminationCapability = new ArrayList<>();
        }
        terminationCapability.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(switchingCapability, encoding, valueLeafFlags, terminationCapability);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultState) {
            DefaultState other = (DefaultState) obj;
            return
                Objects.deepEquals(switchingCapability, other.switchingCapability) &&
                Objects.deepEquals(encoding, other.encoding) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(terminationCapability, other.terminationCapability);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("switchingCapability=" + switchingCapability)
            .add("encoding=" + encoding)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("terminationCapability=" + terminationCapability)
            .toString();
    }


    /**
     * Creates an instance of defaultState.
     */
    public DefaultState() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}