/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of bidirAssociationType.
 */
public abstract class BidirAssociationType {

    /**
     * Returns the attribute bidir-association-type.
     *
     * @return bidir-association-type value of bidir-association-type
     */
    public static String bidirAssociationTypeToString() {
        return "bidir-association-type";
    }

    /**
     * Returns the object of bidirAssociationType fromString input String bidirAssociationType.
     *
     * @param valInString value of input String
     * @return bidirAssociationType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("bidir-association-type")) {
            return BidirAssociationType.class;
        } else if (valInString.equals("bidir-assoc-corouted")) {
            return BidirAssocCorouted.class;
        } else if (valInString.equals("bidir-assoc-non-corouted")) {
            return BidirAssocNonCorouted.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}