/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of switchingPsc1.
 */
public abstract class SwitchingPsc1 extends SwitchingCapabilities {

    /**
     * Returns the attribute switching-psc1.
     *
     * @return switching-psc1 value of switching-psc1
     */
    public static String switchingPsc1ToString() {
        return "switching-psc1";
    }

    /**
     * Returns the object of switchingPsc1 fromString input String switchingPsc1.
     *
     * @param valInString value of input String
     * @return switchingPsc1
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("switching-psc1")) {
            return SwitchingPsc1.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}