/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities.tunnelpathaffinities.style;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities.tunnelpathaffinities.Style;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of values.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultValues extends InnerModelObject implements Values {
    protected long value;
    protected long mask;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public long value() {
        return value;
    }

    @Override
    public long mask() {
        return mask;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void value(long value) {
        valueLeafFlags.set(LeafIdentifier.VALUE.getLeafIndex());
        this.value = value;
    }

    @Override
    public void mask(long mask) {
        valueLeafFlags.set(LeafIdentifier.MASK.getLeafIndex());
        this.mask = mask;
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, mask, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultValues) {
            DefaultValues other = (DefaultValues) obj;
            return
                Objects.deepEquals(value, other.value) &&
                Objects.deepEquals(mask, other.mask) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("value=" + value)
            .add("mask=" + mask)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultValues.
     */
    public DefaultValues() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}