/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities.tunnelpathaffinities.style.named;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.ResourceAffinitiesType;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities.tunnelpathaffinities.style.named.constraints.Constraint;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of constraints.
 */
public interface Constraints extends Augmentable  {

    /**
     * Identify the leaf of Constraints.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents usage.
         */
        USAGE(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute usage.
     *
     * @return usage value of usage
     */
    Class<? extends ResourceAffinitiesType> usage();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute constraint.
     *
     * @return constraint value of constraint
     */
    Constraint constraint();

    /**
     * Sets the attribute usage.
     *
     * @param usage value of usage
     */
    void usage(Class<? extends ResourceAffinitiesType> usage);

    /**
     * Sets the attribute constraint.
     *
     * @param constraint value of constraint
     */
    void constraint(Constraint constraint);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}