/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes;

import java.util.Objects;

/**
 * Represents the implementation of timeticks.
 */
public final class Timeticks {

    private long uint32;

    /**
     * Creates an instance of timeticks.
     */
    private Timeticks() {
    }

    /**
     * Creates an instance of uint32.
     *
     * @param uint32 value of uint32
     */
    public Timeticks(long uint32) {
        this.uint32 = uint32;
    }

    /**
     * Returns the object of timeticks for type uint32.
     *
     * @param value value of timeticks for type uint32
     * @return timeticks for type uint32
     */
    public static Timeticks of(long value) {
        return new Timeticks(value);
    }

    /**
     * Returns the attribute uint32.
     *
     * @return uint32 value of uint32
     */
    public long uint32() {
        return uint32;
    }
    /**
     * Sets the attribute uint32.
     *
     * @param uint32 value of uint32
     */
    public void uint32(long uint32) {
        this.uint32 = uint32;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint32);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Timeticks) {
            Timeticks other = (Timeticks) obj;
            return
                Objects.deepEquals(uint32, other.uint32);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(uint32);
    }
    /**
     * Returns the object of timeticks fromString input String timeticks.
     *
     * @param valInString value of input String
     * @return timeticks
     */
    public static Timeticks fromString(String valInString) {
        try {
            long tmpVal = Long.parseLong(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
