/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes;

import java.util.Objects;

/**
 * Represents the implementation of xpath10.
 */
public final class Xpath10 {

    private String string;

    /**
     * Creates an instance of xpath10.
     */
    private Xpath10() {
    }

    /**
     * Creates an instance of string.
     *
     * @param string value of string
     */
    public Xpath10(String string) {
        this.string = string;
    }

    /**
     * Returns the object of xpath10 for type string.
     *
     * @param value value of xpath10 for type string
     * @return xpath10 for type string
     */
    public static Xpath10 of(String value) {
        return new Xpath10(value);
    }

    /**
     * Returns the attribute string.
     *
     * @return string value of string
     */
    public String string() {
        return string;
    }
    /**
     * Sets the attribute string.
     *
     * @param string value of string
     */
    public void string(String string) {
        this.string = string;
    }

    @Override
    public int hashCode() {
        return Objects.hash(string);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Xpath10) {
            Xpath10 other = (Xpath10) obj;
            return
                Objects.deepEquals(string, other.string);
        }
        return false;
    }

    @Override
    public String toString() {
        return string;
    }
    /**
     * Returns the object of xpath10 fromString input String xpath10.
     *
     * @param valInString value of input String
     * @return xpath10
     */
    public static Xpath10 fromString(String valInString) {
        try {
            String tmpVal = (valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
