/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.Subscriptions;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.Test;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of yrtSubscription.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YrtSubscriptionOpParam extends InnerModelObject implements YrtSubscription {
    protected Subscriptions subscriptions;
    protected Test test;

    @Override
    public Subscriptions subscriptions() {
        return subscriptions;
    }

    @Override
    public Test test() {
        return test;
    }

    @Override
    public void subscriptions(Subscriptions subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Override
    public void test(Test test) {
        this.test = test;
    }

    @Override
    public int hashCode() {
        return Objects.hash(subscriptions, test);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YrtSubscriptionOpParam) {
            YrtSubscriptionOpParam other = (YrtSubscriptionOpParam) obj;
            return
                Objects.deepEquals(subscriptions, other.subscriptions) &&
                Objects.deepEquals(test, other.test);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("subscriptions=" + subscriptions)
            .add("test=" + test)
            .toString();
    }

    /**
     * Creates an instance of yrtSubscriptionOpParam.
     */
    public YrtSubscriptionOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}