/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription;

import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.changetype.ChangeTypeEnum;
import java.util.Objects;

/**
 * Represents the implementation of changeType.
 */
public final class ChangeType {

    private ChangeTypeEnum enumeration;

    /**
     * Creates an instance of changeType.
     */
    private ChangeType() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public ChangeType(ChangeTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of changeType for type enumeration.
     *
     * @param value value of changeType for type enumeration
     * @return changeType for type enumeration
     */
    public static ChangeType of(ChangeTypeEnum value) {
        return new ChangeType(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public ChangeTypeEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(ChangeTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChangeType) {
            ChangeType other = (ChangeType) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of changeType fromString input String changeType.
     *
     * @param valInString value of input String
     * @return changeType
     */
    public static ChangeType fromString(String valInString) {
        try {
            ChangeTypeEnum tmpVal = ChangeTypeEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
