/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription;

import java.util.Objects;

/**
 * Represents the implementation of streamType.
 */
public final class StreamType {

    private Class<? extends Stream> identityref;

    /**
     * Creates an instance of streamType.
     */
    private StreamType() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public StreamType(Class<? extends Stream> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of streamType for type identityref.
     *
     * @param value value of streamType for type identityref
     * @return streamType for type identityref
     */
    public static StreamType of(Class<? extends Stream> value) {
        return new StreamType(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends Stream> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends Stream> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StreamType) {
            StreamType other = (StreamType) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(Stream.class)) {
            return Stream.streamToString();
        } else if (identityref.equals(Netconf.class)) {
            return Netconf.netconfToString();
        } else if (identityref.equals(Syslog.class)) {
            return Syslog.syslogToString();
        }
        return null;
    }
    /**
     * Returns the object of streamType fromString input String streamType.
     *
     * @param valInString value of input String
     * @return streamType
     */
    public static StreamType fromString(String valInString) {
        try {
            Class<? extends Stream> tmpVal = Stream.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
